// priority: 10
let 启用生物刷新调试日志 = false;
let 生物刷新调试日志 = (参数) => {
    if (启用生物刷新调试日志) {
        console.log("[生物刷新控制]", 参数);
    }
};

let 刷怪笼扫描半径XZ = 4;
let 刷怪笼扫描半径Y = 2;
let 通知半径 = 16;
let 刷怪笼生成计数值数据 = "MDF_SpawnerCount";
let 指令控制_刷怪笼损坏_全局启用键 = "spawnerDamage_state_byCmd";

let 全部难度生物刷新配置 = {
    "EASY": EASY生物刷新配置,
    "CLASSIC": CLASSIC生物刷新配置,
    "MASTER": MASTER生物刷新配置,
    "MYTHIC": MYTHIC生物刷新配置
};

NativeEvents.onEvent(Java.loadClass("net.minecraftforge.event.entity.living.MobSpawnEvent$FinalizeSpawn"), e => {
    let 实体 = e.getEntity();
    let s = Utils.server;
    let 世界 = e.getLevel();

    if (!实体 || !实体.getType() || !s || !s.persistentData || !世界) return;
    let sDATA = s.persistentData;
    let 实体ID = $实体类.getKey(实体.getType()).toString();
    let 方块位置 = 实体.blockPosition();
    let 事件维度 = String(世界.dimension);
    let 生成方式 = "INITIALLY_UNKNOWN";

    if (实体 && typeof e.getSpawnType === "function") {
        let 生成类型 = e.getSpawnType();
        if (生成类型 !== null && 生成类型 !== undefined) {
            生成方式 = 生成类型.toString();
            if (生成方式 === null || 生成方式.toLowerCase() === "null" || 生成方式.trim() === "" || (typeof 生成方式 === "string" && typeof $生物刷新类型 === "object" && $生物刷新类型 && 生成方式.startsWith($生物刷新类型.toString()))) {
                生成方式 = "SPAWNTYPE_INVALID_STRING";
            }
        } else { 生成方式 = "SPAWNTYPE_WAS_NULL_OR_UNDEFINED"; }
    } else { 生成方式 = "NO_EVENT_GETSPAWNTYPE_METHOD"; }
    
    if (实体生成控制列表 && 实体ID in 实体生成控制列表) {
        let 当前控制配置对象 = 实体生成控制列表[实体ID];
        let 当前控制规则 = null;
        let 维度黑名单 = [];
        let 维度白名单 = [];
        if (typeof 当前控制配置对象 === "string") {
            当前控制规则 = 当前控制配置对象;
        } else if (typeof 当前控制配置对象 === "object" && 当前控制配置对象 !== null) {
            当前控制规则 = (typeof 当前控制配置对象.rule === "string") ? 当前控制配置对象.rule : null;
            维度黑名单 = Array.isArray(当前控制配置对象.维度黑名单) ? 当前控制配置对象.维度黑名单 : [];
            维度白名单 = Array.isArray(当前控制配置对象.维度白名单) ? 当前控制配置对象.维度白名单 : [];
        }

        if (!事件维度.includes("unknown") && !事件维度.includes("object")) {
            if (维度白名单.length > 0) {
                if (!维度白名单.includes(事件维度)) {
                    生物刷新调试日志(`[实体生成控制-维度规则] 实体: ${实体ID}, 生成方式: ${生成方式}, 维度: ${事件维度}. 原因: 不在维度白名单 [${维度白名单.join(",")}] 中.`);
                    if(e.isCancelable()) e.setSpawnCancelled(true); else e.setCanceled(true);
                    return;
                }
            } else if (维度黑名单.length > 0) {
                if (维度黑名单.includes(事件维度)) {
                    生物刷新调试日志(`[实体生成控制-维度规则] 实体: ${实体ID}, 生成方式: ${生成方式}, 维度: ${事件维度}. 原因: 处在维度黑名单 [${维度黑名单.join(",")}] 中.`);
                    if(e.isCancelable()) e.setSpawnCancelled(true); else e.setCanceled(true);
                    return;
                }
            }
        }

        if (当前控制规则 !== null && 生成方式 !== null && !生成方式.startsWith("SPAWNTYPE_") && !生成方式.startsWith("NO_") && 实体生成类型映射 && (生成方式 in 实体生成类型映射)) {
            let 规则对应标记 = 实体生成类型映射[生成方式];
            if (!当前控制规则.includes(规则对应标记)) {
                生物刷新调试日志(`[实体生成控制-类型规则] 实体: ${实体ID}, 生成方式: ${生成方式} (标记: ${规则对应标记}), 维度: ${事件维度}. 原因: 不符合类型规则 "${当前控制规则}".`);
                if (生成方式 === "SPAWNER") {
                    生物刷新调试日志(`[刷怪笼禁止] ${实体ID} 因生成类型规则 (${生成方式} -> ${规则对应标记}) 被禁止从刷怪笼生成。`);
                }
                if(e.isCancelable()) e.setSpawnCancelled(true); else e.setCanceled(true);
                return;
            }
        }
    }

    let 生效难度 = 默认难度;
    let 检测到最高难度 = -1;
    let 检测半径 = 128;
    let 搜索区域 = new $AABB(方块位置.x - 检测半径, 方块位置.y - 检测半径, 方块位置.z - 检测半径, 方块位置.x + 检测半径, 方块位置.y + 检测半径, 方块位置.z + 检测半径);
    let 附近玩家列表 = [];
    try {
        let 区域内潜在玩家 = 世界.getEntitiesOfClass($玩家, 搜索区域, player => player.isAlive() && !player.isSpectator());
        区域内潜在玩家.forEach(p => 附近玩家列表.push(p));
    } catch (err) {
        生物刷新调试日志(`获取附近玩家列表时出错 (可能为WorldGenRegion): ${err}`);
    }

    for (let p of 附近玩家列表) {
        if (!p || !p.level || typeof p.level.dimension === "undefined") continue;
        let 玩家维度文本 = String(p.level.dimension);
        if (事件维度 === "未知维度" || 玩家维度文本 === "获取失败" || 事件维度 !== 玩家维度文本) continue;
        for (let i = 0; i < 难度标签键名数组.length; i++) {
            let 检查的阶段 = 难度阶段前缀 + 难度标签键名数组[i];
            if (p.stages && typeof p.stages.has === "function" && p.stages.has(检查的阶段)) {
                if (i > 检测到最高难度) 检测到最高难度 = i;
            }
        }
    }
    if (检测到最高难度 > -1 && 检测到最高难度 < 难度标签键名数组.length) {
        生效难度 = 难度标签键名数组[检测到最高难度];
    }
    let 当前难度下的总配置 = 全部难度生物刷新配置[生效难度];
    if (!当前难度下的总配置) {
        生物刷新调试日志(`[警告] 未找到生效难度 "${生效难度}" 的配置, 回退到默认难度 "${默认难度}"`);
        生效难度 = 默认难度;
        当前难度下的总配置 = 全部难度生物刷新配置[生效难度];
    }

    if (当前难度下的总配置 && 当前难度下的总配置[实体ID]) {
        let 单个生物配置 = 当前难度下的总配置[实体ID];
        if (生成方式 === "NATURAL") {
            if (单个生物配置 && typeof 单个生物配置.数量上限 === "number" && 单个生物配置.数量上限 >= 0) {
                let 最大允许数量 = 单个生物配置.数量上限;
                if (最大允许数量 === 0) {
                    生物刷新调试日志(`[自然生成限制][${生效难度}] ${实体ID} (${生成方式}) 生成上限为0, 取消生成。`);
                    if (e.isCancelable()) e.setSpawnCancelled(true); else e.setCanceled(true);
                    return;
                }
                let 当前数量 = 0;
                let 计数区域 = new $AABB(方块位置.x - 检测半径, 方块位置.y - 检测半径, 方块位置.z - 检测半径, 方块位置.x + 检测半径, 方块位置.y + 检测半径, 方块位置.z + 检测半径);
                try {
                    let 区域内同类实体 = 世界.getEntitiesOfClass($实体, 计数区域, ent => $实体类.getKey(ent.getType()).toString() === 实体ID && ent.isAlive());
                    当前数量 = 区域内同类实体.size();
                } catch (err) {
                    生物刷新调试日志(`获取区域内同类实体计数时出错 (可能为WorldGenRegion): ${err}`);
                }

                if (当前数量 >= 最大允许数量) {
                    生物刷新调试日志(`[自然生成限制][${生效难度}] ${实体ID} (${生成方式}) 当前数量 ${当前数量} 已达上限 ${最大允许数量}, 取消生成。`);
                    if (e.isCancelable()) e.setSpawnCancelled(true); else e.setCanceled(true);
                    return;
                }
            } else if (单个生物配置 && 单个生物配置.数量上限 === "") {
                生物刷新调试日志(`[自然生成限制][${生效难度}] ${实体ID} (${生成方式}) 的数量上限配置为 "" (空字符串), 跳过此实体的数量上限检查。`);
            }
        }
    }
    let 实际启用刷怪笼损坏 = sDATA.getBoolean(指令控制_刷怪笼损坏_全局启用键);

    if (实际启用刷怪笼损坏 && 生成方式 === "SPAWNER") {
        let 原生所在世界 = 世界;
        let 记录的维度位置 = String(原生所在世界.dimension);
        生物刷新调试日志(`[刷怪笼处理] 检测到实体 ${实体ID} 从刷怪笼生成。原生世界维度: ${记录的维度位置}, 事件维度文本: ${事件维度}`);
        let 刷怪笼 = null;
        let 最小匹配距离平方 = Infinity;

        for (let 横向偏移 = -刷怪笼扫描半径XZ; 横向偏移 <= 刷怪笼扫描半径XZ; 横向偏移++) {
            for (let 纵向偏移 = -刷怪笼扫描半径Y; 纵向偏移 <= 刷怪笼扫描半径Y; 纵向偏移++) {
                for (let 侧向偏移 = -刷怪笼扫描半径XZ; 侧向偏移 <= 刷怪笼扫描半径XZ; 侧向偏移++) {
                    let 当前检查位置 = 方块位置.offset(横向偏移, 纵向偏移, 侧向偏移);
                    if (typeof 原生所在世界.getBlock !== "function" || typeof 原生所在世界.getBlockEntity !== "function") {
                        生物刷新调试日志(`[刷怪笼处理] 世界对象 ${原生所在世界.getClass().getName()} 不支持 getBlock/getBlockEntity。`);
                        break;
                    }
                    let 当前方块实例 = 原生所在世界.getBlock(当前检查位置);
                    if (当前方块实例.id === "minecraft:spawner") {
                        let 刷怪笼宣称生成实体ID = null;
                        let 潜在刷怪笼方块实体 = 原生所在世界.getBlockEntity(当前检查位置);

                        if (潜在刷怪笼方块实体) {
                            let 刷怪笼NBT数据 = 潜在刷怪笼方块实体.saveWithoutMetadata();
                            if (刷怪笼NBT数据.contains("SpawnData", 10)) {
                                let 生成数据标签 = 刷怪笼NBT数据.getCompound("SpawnData");
                                if (生成数据标签.contains("entity", 10)) {
                                    let 实体标签 = 生成数据标签.getCompound("entity");
                                    if (实体标签.contains("id", 8)) 刷怪笼宣称生成实体ID = 实体标签.getString("id");
                                } else if (生成数据标签.contains("id", 8)) {
                                    刷怪笼宣称生成实体ID = 生成数据标签.getString("id");
                                }
                            }
                        }
                        if (刷怪笼宣称生成实体ID === 实体ID) {
                            let 距离平方 = 当前检查位置.distSqr(方块位置);
                            if (距离平方 < 最小匹配距离平方) {
                                最小匹配距离平方 = 距离平方;
                                刷怪笼 = 当前检查位置;
                            }
                        }
                    }
                }
                 if (typeof 原生所在世界.getBlock !== "function") break;
            }
             if (typeof 原生所在世界.getBlock !== "function") break;
        }

        if (刷怪笼) {
            生物刷新调试日志(`[刷怪笼处理] ${实体ID} 由 ${刷怪笼} 的刷怪笼生成。`);
            if (typeof 原生所在世界.getBlockEntity !== "function") {
                 生物刷新调试日志(`[刷怪笼处理] 世界对象 ${原生所在世界.getClass().getName()} 不支持 getBlockEntity 无法获取刷怪笼实体数据。`);
            } else {
                let 原生刷怪笼方块实体 = 原生所在世界.getBlockEntity(刷怪笼);
                if (typeof $原生方块实体基类 === "undefined") { 生物刷新调试日志("错误: 全局变量 '$原生方块实体基类' 未定义。"); return; }
                if (!原生刷怪笼方块实体 || !($原生方块实体基类 && 原生刷怪笼方块实体 instanceof $原生方块实体基类) || typeof 原生刷怪笼方块实体.getPersistentData !== "function") {
                    生物刷新调试日志(`[刷怪笼处理] ${刷怪笼} 的方块实体无效, 或不是 $原生方块实体基类 实例, 或缺少 getPersistentData 方法.`);
                } else {
                    let 刷怪笼持久化数据 = 原生刷怪笼方块实体.getPersistentData();
                    let 当前生成计数值 = 刷怪笼持久化数据.contains(刷怪笼生成计数值数据, 3) ? 刷怪笼持久化数据.getInt(刷怪笼生成计数值数据) : 0;
                    当前生成计数值++;
                    生物刷新调试日志(`[刷怪笼处理] ${刷怪笼} 生成计数值: ${当前生成计数值}`);

                    if (当前生成计数值 >= 刷怪笼最大损坏阈值) { 
                        生物刷新调试日志(`[刷怪笼处理] ${刷怪笼} 已达损坏阈值 (${刷怪笼最大损坏阈值})，正在损坏...`);
                        if (typeof 原生所在世界.setBlock === "function" && typeof 原生所在世界.getEntitiesOfClass === "function") {
                            原生所在世界.setBlock(刷怪笼, Block.id("minecraft:air").blockState, 3);
                            let 通知搜索区域 = new $AABB(刷怪笼.x - 通知半径, 刷怪笼.y - 通知半径, 刷怪笼.z - 通知半径, 刷怪笼.x + 通知半径, 刷怪笼.y + 通知半径, 刷怪笼.z + 通知半径);
                            try {
                                let 通知区域内玩家 = 原生所在世界.getEntitiesOfClass($玩家, 通知搜索区域, p => p.isAlive() && !p.isSpectator());
                                通知区域内玩家.forEach(待通知实体 => {
                                    待通知实体.tell(Text.of(`一个位于 ${刷怪笼.x},${刷怪笼.y},${刷怪笼.z} 的 ${实体ID} 刷怪笼因过度使用而损坏了!`).red());
                                });
                            } catch (err) {
                                生物刷新调试日志(`刷怪笼损坏通知玩家时出错 (可能为WorldGenRegion): ${err}`);
                            }
                        } else {
                             生物刷新调试日志(`[刷怪笼处理] 世界对象 ${原生所在世界.getClass().getName()} 不支持 setBlock 或 getEntitiesOfClass, 无法损坏刷怪笼或通知。`);
                        }
                    } else {
                        刷怪笼持久化数据.putInt(刷怪笼生成计数值数据, 当前生成计数值);
                        原生刷怪笼方块实体.setChanged();
                    }
                }
            }
        } else {
             生物刷新调试日志(`[刷怪笼处理] 未找到与实体 ${实体ID} (位置: ${方块位置}) 匹配的附近刷怪笼。`);
        }
    }
    生物刷新调试日志(`[生成尝试处理完毕] 实体: ${实体ID}, 生成方式: ${生成方式}, 维度: ${事件维度}, 是否被取消: ${e.isCanceled()}`);
});